/**
 * Beschrijft het gedrag van een ridder in een computergame.
 * 
 * @author Dominiek Vandewalle
 * @version 2015-06-30
 */
public class Ridder
{
    //velden
    private String naam;
    private double gezondheid;
    private Harnas harnas;

    /**
     * Constructor voor objecten van de klasse Ridder.
     * Ridders worden geboren met 100 procent gezondheid en slechts 1 leven
     * @param   naam    De naam van ridder.
     */
    public Ridder(String naam)
    {
        this.naam = naam;
        gezondheid = 100;
    }

    /**
     * Geeft de naam van de ridder terug.
     * @return     De naam van de ridder. 
     */
    public String getNaam()
    {
        return naam;
    }

    /**
     * Geeft het aantal levens van de ridder terug.
     * @return     Het aantal levens van de ridder.
     */
    public double getGezondheid()
    {
        return gezondheid;
    }

    /**
     * Geeft het harnas van de ridder terug.
     * @return     Het harnas van de ridder.
     */
    public Harnas getHarnas()
    {
        return harnas;
    }

    /**
     * Geeft aan of de ridder al dan niet dood is.
     * @return     True indien de ridder dood is, anders false.
     */
    public boolean isDood()
    {
        return gezondheid == 0;
    }

    /**
     * Een andere ridder aanvallen.
     * @param   tegenstander  De ridder die wordt aangevallen.
     */
    public void aanvallen(Ridder tegenstander)
    {
        tegenstander.geraakt();
    }

    /**
     * Indien de ridder geraakt wordt, dan verliest de ridder 1 leven.
     */
    public void geraakt()
    {
        if(harnas != null)
        {
            double factor = harnas.getBeschermingsfactor();
            gezondheid -= (1 - factor) * 100;
            gezondheid = Math.max(gezondheid,0);
        }
        else
        {
            gezondheid = 0;
        }
    }

    /**
     * Ridderobject trekt een bestaand harnas aan.
     * @param   harnas  Het harnas dat de ridder aantrekt.
     */
    public void setHarnas(Harnas harnas)
    {
        this.harnas = harnas;
    }

    /**
     * Ridderobject trekt een nog aan te maken harnas aan.
     * @param   type                Het type van het harnas.
     * @param   beschermingsfactor  De beschermingsfactor van het harnas.
     */
    public void nieuwHarnasAantrekken(String type, double beschermingsfactor)
    {
        harnas = new Harnas(type, beschermingsfactor);
    }

    /**
     * Het harnas uittrekken.
     */
    public void harnasUittrekken()
    {
        harnas = null;
    }

    /**
     * Toont informatie over de ridder in het terminalvenster.
     */
    public void print()
    {
        String info = "Naam: " + naam + "\n";
        info += "Gezondheid: " + gezondheid + "\n";

        if(harnas != null)
        {
            info += harnas.toString();
        }

        System.out.println(info);
    }
}